function prostaiteracija(e)

% prvo resenje je u intervalu [-0.53,-0.52], i f(-0.53)*f(-0.52)<0
% g(x)=(4/5)*exp(x)-1 i |g'(x)|<1 na intervalu
% q je maximum po modulu g'(x)

briteracija1=[];  % niz u kojem pamtimo broj iteracija
a=-0.53;
b=-0.52;
q=0.4756;
for j=1:length(e)
    x0=(a+b)/2;
    x1=(4/5)*exp(x0)-1;
    i=0;
    while (abs(x0-x1) > (q*e(j)) )    % kriterijum zaustavljanja
        x0=x1;
        x1=(4/5)*exp(x0)-1;
        i=i+1;
    end
    briteracija1=[briteracija1,i];
end
prvo_resenje_je=x1

% drugo resenje je u intervalu [0.5,1.0] i f(0.5)*f(1)<0
% g(x)=log((5/4)*(x0+1)) i |g'(x)|<1 na intervalu

briteracija2=[];  %niz u kojem pamtimo broj iteracija
a1=0.5;
b1=1;
q1=0.0913;
for j=1:length(e)
    x0=(a1+b1)/2;
    x1=log((5/4)*(x0+1));
    i=0;
    while (abs(x0-x1) > (q1*e(j)))
        x0=x1;
        x1=log((5/4)*(x0+1));
        i=i+1;
    end
    briteracija2=[briteracija2,i];
end
drugo_resenje_je=x1

hold off
hold on
plot(e,briteracija1,'r');
plot(e,briteracija2,'g');